/*
 * Copyright European Commission's
 * Taxation and Customs Union Directorate-General (DG TAXUD).
 */
package eu.europa.ec.taxud.cesop.domain;

/**
 * Enum for PaymentDataMsgPart content types.
 */
public enum PaymentDataMsgPartContentType {

    /**
     * Reported payee payment data msg part content type.
     */
    REPORTED_PAYEE("P"),
    /**
     * Reported transactions payment data msg part content type.
     */
    REPORTED_TRANSACTIONS("T");

    private final String label;

    PaymentDataMsgPartContentType(final String label) {
        this.label = label;
    }

    /**
     * Gets label.
     *
     * @return the label
     */
    public String getLabel() {
        return this.label;
    }

    /**
     * Find a {@link PaymentDataMsgPartContentType} by its label.
     *
     * @param label the label
     * @return the PaymentDataMsgPartContentType
     * @throws IllegalArgumentException if there is no value for the label
     */
    public static PaymentDataMsgPartContentType findByLabel(final String label) {
        for (final PaymentDataMsgPartContentType value : values()) {
            if (value.getLabel().equals(label)) {
                return value;
            }
        }
        throw new IllegalArgumentException("No PaymentDataMsgPartContentType found for label: " + label);
    }
}
